/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1;

import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1.ExtendedSliderButton;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RangeSliderButton
extends ExtendedSliderButton {
    private static final Logger LOGGER = LogManager.getLogger();
    public double minValue;
    public double maxValue;

    public RangeSliderButton(int x, int y, int width, int height, boolean handleClick, double minRangeValue, double maxRangeValue, double selectedRangeValue, Consumer<ExtendedSliderButton> applyValueCallback) {
        super(x, y, width, height, handleClick, 0.0, applyValueCallback);
        this.minValue = minRangeValue;
        this.maxValue = maxRangeValue;
        this.setSelectedRangeValue(selectedRangeValue);
        this.updateMessage();
    }

    @Override
    public String getSliderMessageWithoutPrefixSuffix() {
        return "" + this.getSelectedRangeValue();
    }

    public int getSelectedRangeValue() {
        return (int)Mth.lerp((double)Mth.clamp((double)this.value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
    }

    public double getSelectedRangeDoubleValue() {
        return Mth.lerp((double)Mth.clamp((double)this.value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
    }

    public void setSelectedRangeValue(double rangeValue) {
        this.setValue((Mth.clamp((double)rangeValue, (double)this.minValue, (double)this.maxValue) - this.minValue) / (this.maxValue - this.minValue));
    }
}

